<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/t2', function () {
});

Route::get('dashboard', [App\Http\Controllers\FrontController::class, 'index'])->name("dash");
Route::get('all/regions', [App\Http\Controllers\FrontController::class, 'AllRegions'])->name("regions.all");
Route::get('cameras/{pagenumber}/{regionid}', [App\Http\Controllers\FrontController::class, 'cameras'])->name("cameras.list");
Route::get('camera/views/{camera_id}', [App\Http\Controllers\FrontController::class, 'cameras_details'])->name("camera.details");
Route::get('camera/faces/{frame_id}', [App\Http\Controllers\FrontController::class, 'faceDetections'])->name("face.list");


// AddDatacontroller


Route::get('all/cameras', [App\Http\Controllers\AddDataController::class, 'view_all_cameras'])->name("all.cameras.lists");
Route::get('region/add', [App\Http\Controllers\AddDataController::class, 'add_region_view'])->name("region.add");
Route::post('region/add', [App\Http\Controllers\AddDataController::class, 'add_new_region'])->name("region.save");



// AjaxController
Route::post('cameras', [App\Http\Controllers\AjaxController::class, 'totalCameras'])->name("cameras.all");
Route::get('genderage/data', [App\Http\Controllers\AjaxController::class, 'LoadGenderAgeData']);
Route::post('genderage/data', [App\Http\Controllers\AjaxController::class, 'LoadGenderAgeData'])->name("general.data");

Route::get("t", function () {
    $uri = "mongodb://localhost:27017"; // Replace with your local MongoDB server's address and port

    $client = new MongoDB\Client(
        $uri,
        [],
        ['typeMap' => ['root' => 'array', 'document' => 'array']]
    );

    // $uri = "mongodb+srv://abdullahmasoodx:miG0JPZFrg2LJn6U@imageprocessing.vjt2aot.mongodb.net/?retryWrites=true&w=majority";

    // $client = new MongoDB\Client(
    //     $uri
    // );

    //$database = $client->framedata;
    //  $database->command(['ping'=>1]);
    $collection = $client->dataprocess->imagesinfo;

    $cursor = $collection->countDocuments();
    echo "Total documents in the collection: " . $cursor;


    //     $filter = [];

    //     $projection = [
    //         'actual_frame_path' => 0,
    //         'frame_image' => 0,
    //         'created_at' => 0,
    //         "frame_id" => 0,
    //         "_id" => 0,
    //         "face_details.BoundingBox" => 0,
    //         "face_details.Smile" => 0,
    //         "face_details.Eyeglasses" => 0,
    //         "face_details.Sunglasses" => 0,
    //         "face_details.Beard" => 0,
    //         "face_details.Mustache" => 0,
    //         "face_details.MouthOpen" => 0,
    //         "face_details.EyesOpen" => 0,
    //         "face_details.Emotions" => 0,
    //         "face_details.Landmarks" => 0,
    //         "face_details.Pose" => 0,
    //         "face_details.Quality" => 0,
    //         "face_details.FaceOccluded" => 0,
    //         "face_details.EyeDirection" => 0,
    //         // ]
    //     ];

    //     $options = [];

    //     $cursor = $collection->find($filter, ['projection' => $projection] + $options);
    //     //
    //     $genderData = [];
    //     foreach ($cursor as $result) {
    //         $genderData[] = $result['face_details']['AgeRange'];
    //     }
    //    // return $genderData;
    //     return view("text", compact('genderData'));
});

Route::post('/your-route-url', function () {
    // Your server-side logic here
    return response()->json(['message' => 'Request received successfully']);
});
